% plux_ci_transfer_function_1.m
%
global x_coords;
global y_coords;
global z_vals;

x_coords = double([1 1 1 2 2 2 3 3 3]);
y_coords = double([1 2 3 1 2 3 1 2 3]);
z_vals   = double([0 1 2 0 0.5 1.0 0 0 0]);

%
% parameters for pLux_cI promoter
%
c0 = 0.04;
c1 = 0.05;
c2 = 0.11;
luxR_tot = 2000; % nM
K_A_2__K_LuxR = 270000;  % nM^3
K_D_CI = 5;  % nM
n = 1.5;


%
% overall pLux_cI function
%
%   inputs: u1 = AHL 
%           u2 = CI
%
u1_range = 10.^(-4.0 : 0.1 : 3.00);
u2_range = 10.^(-4.0 : 0.1 : 3.00);

x = 0;

for u1 = u1_range
    x = x + 1;
    y = 0;
    
    for u2 = u2_range
        y = y + 1;
        x_pos(x,y) = u1;
        y_pos(x,y) = u2;

        flux = (1/2) * ((luxR_tot + (K_A_2__K_LuxR / (4 * (u1^2)))) - ...
                        sqrt((luxR_tot + (K_A_2__K_LuxR / (4 * (u1^2))))^2 - (luxR_tot^2)));
                  
        fci   = (u2 / 2) + (1 / (8 * K_D_CI)) * (1 - sqrt(1 + 8 * K_D_CI * u2));
        
        f(x,y) = (c0 + c1 * flux ) / (1 + c0 + c1 * flux + c2 * (fci^n) + c1 * c2 * flux * (fci^n));      

    end
end

contourf(x_pos,y_pos,f);

set (gca,'xscale', 'log');
set (gca,'yscale', 'log');

xlabel('AHL');
ylabel('CI');
%shading interp;
colorbar;


        
 

                     